#include <bits/stdc++.h>
 
using namespace std;

const long double eps = 1e-8;

const int MAX = 150005;

int n, x[MAX], v[MAX], fenw[MAX], order[MAX];
long long k;
long double pos[MAX];

void Modify(int p, int v) {
  for (p += 1; p <= n; p += p & -p) {
    fenw[p] += v;
  }
}

int Query(int p) {
  int res = 0;
  for (p += 1; p; p -= p & -p) {
    res += fenw[p];
  }
  return res;
}

bool Check(long double t) {
  for (int i = 0; i < n; i++) {
    pos[i] = (long double) x[i] + t * (long double) v[i];
    order[i] = i;
    fenw[i + 1] = 0;
  }
  sort(order, order + n, [&](int i, int j) {
    if (abs(pos[i] - pos[j]) < eps) {
      return i > j;
    } else {
      return pos[i] < pos[j];
    }
  });
  long long total = 0;
  for (int i = 0; i < n; i++) {
    total += i - Query(order[i]);
    Modify(order[i], +1);
  }
  return total >= k;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);
  cin >> n >> k;
  for (int i = 0; i < n; i++) {
    cin >> x[i] >> v[i];
  }
  long double low = 0, high = 1e9, ans = 1e9;
  for (int iter = 0; iter < 60; iter++) {
    long double mid = (low + high) / 2;
    if (Check(mid)) {
      ans = mid;
      high = mid;
    } else {
      low = mid;
    }
  }
  cout << fixed << setprecision(6) << ans << '\n';
  return 0;
}